--
-- NOTE:
--
-- File paths need to be edited. Search for $$PATH$$ and
-- replace it with the path to the directory containing
-- the extracted data files.
--
--
-- PostgreSQL database dump
--

SET statement_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = off;
SET check_function_bodies = false;
SET client_min_messages = warning;
SET escape_string_warning = off;

SET search_path = public, pg_catalog;

ALTER TABLE ONLY public.auth_user_user_permissions DROP CONSTRAINT user_id_refs_id_4dc23c39;
ALTER TABLE ONLY public.auth_user_groups DROP CONSTRAINT user_id_refs_id_40c41112;
ALTER TABLE ONLY public.auth_group_permissions DROP CONSTRAINT group_id_refs_id_f4b32aac;
ALTER TABLE ONLY public.django_admin_log DROP CONSTRAINT django_admin_log_user_id_fkey;
ALTER TABLE ONLY public.django_admin_log DROP CONSTRAINT django_admin_log_content_type_id_fkey;
ALTER TABLE ONLY public.dependencias_perfil DROP CONSTRAINT dependencias_perfil_usuario_id_fkey;
ALTER TABLE ONLY public.dependencias_perfil DROP CONSTRAINT dependencias_perfil_tipo_id_fkey;
ALTER TABLE ONLY public.dependencias_perfil DROP CONSTRAINT dependencias_perfil_direccion_id_fkey;
ALTER TABLE ONLY public.auth_permission DROP CONSTRAINT content_type_id_refs_id_d043b34a;
ALTER TABLE ONLY public.auth_user_user_permissions DROP CONSTRAINT auth_user_user_permissions_permission_id_fkey;
ALTER TABLE ONLY public.auth_user_groups DROP CONSTRAINT auth_user_groups_group_id_fkey;
ALTER TABLE ONLY public.auth_group_permissions DROP CONSTRAINT auth_group_permissions_permission_id_fkey;
ALTER TABLE ONLY public.anuencias_tecnicas_usuario_dependencia DROP CONSTRAINT anuencias_tecnicas_usuario_dependencia_usuario_id_fkey;
ALTER TABLE ONLY public.anuencias_tecnicas_usuario_dependencia DROP CONSTRAINT anuencias_tecnicas_usuario_dependencia_dependencia_id_fkey;
ALTER TABLE ONLY public.anuencias_tecnicas_revision DROP CONSTRAINT anuencias_tecnicas_revision_usuario_id_fkey;
ALTER TABLE ONLY public.anuencias_tecnicas_perfil DROP CONSTRAINT anuencias_tecnicas_perfil_usuario_id_fkey;
ALTER TABLE ONLY public.anuencias_tecnicas_perfil DROP CONSTRAINT anuencias_tecnicas_perfil_tipo_id_fkey;
ALTER TABLE ONLY public.anuencias_tecnicas_perfil DROP CONSTRAINT anuencias_tecnicas_perfil_direccion_id_fkey;
ALTER TABLE ONLY public.anuencias_tecnicas_estatus DROP CONSTRAINT anuencias_tecnicas_estatus_usuario_id_fkey;
ALTER TABLE ONLY public.anuencias_tecnicas_book DROP CONSTRAINT anuencias_tecnicas_book_author_id_fkey;
ALTER TABLE ONLY public.anuencias_tecnicas_autorizacion DROP CONSTRAINT anuencias_tecnicas_autorizacion_usuario_id_fkey;
ALTER TABLE ONLY public.anuencias_tecnicas_articulos DROP CONSTRAINT anuencias_tecnicas_articulos_usuario_id_fkey;
ALTER TABLE ONLY public.anuencias_tecnicas_anuencia_detalle DROP CONSTRAINT anuencias_tecnicas_anuencia_detalle_usuario_id_fkey;
ALTER TABLE ONLY public.anuencias_tecnicas_anuencia_detalle DROP CONSTRAINT anuencias_tecnicas_anuencia_detalle_proyecto_id_fkey;
ALTER TABLE ONLY public.anuencias_tecnicas_anuencia_detalle DROP CONSTRAINT anuencias_tecnicas_anuencia_detalle_partida_id_fkey;
ALTER TABLE ONLY public.anuencias_tecnicas_anuencia_detalle DROP CONSTRAINT anuencias_tecnicas_anuencia_detalle_categoria_id_fkey;
ALTER TABLE ONLY public.anuencias_tecnicas_anuencia_detalle DROP CONSTRAINT anuencias_tecnicas_anuencia_detalle_anuencia_id_fkey;
ALTER TABLE ONLY public.anuencias_tecnicas_anuencia_datos DROP CONSTRAINT anuencias_tecnicas_anuencia_datos_usuario_id_fkey;
ALTER TABLE ONLY public.anuencias_tecnicas_anuencia_datos DROP CONSTRAINT anuencias_tecnicas_anuencia_datos_estatus_id_fkey;
ALTER TABLE ONLY public.anuencias_tecnicas_anuencia_datos DROP CONSTRAINT anuencias_tecnicas_anuencia_datos_dependencias_id_fkey;
ALTER TABLE ONLY public.anuencias_tecnicas_addproyectos DROP CONSTRAINT anuencias_tecnicas_addproyectos_dependencia_id_fkey;
ALTER TABLE ONLY public.anuencias_tecnicas_addpartidas_proyectos DROP CONSTRAINT anuencias_tecnicas_addpartidas_proyectos_addproyectos_id_fkey;
ALTER TABLE ONLY public.dependencias_adscripcion DROP CONSTRAINT adscripcion_padre_id_refs_id_8b3e7743;
ALTER TABLE ONLY public.anuencias_tecnicas_addpartidas_proyectos DROP CONSTRAINT addpartidas_id_refs_id_7ef15694;
DROP INDEX public.django_session_session_key_like;
DROP INDEX public.django_session_expire_date;
DROP INDEX public.django_admin_log_user_id;
DROP INDEX public.django_admin_log_content_type_id;
DROP INDEX public.dependencias_perfil_usuario_id;
DROP INDEX public.dependencias_perfil_tipo_id;
DROP INDEX public.dependencias_perfil_direccion_id;
DROP INDEX public.dependencias_adscripcion_adscripcion_padre_id;
DROP INDEX public.auth_user_username_like;
DROP INDEX public.auth_user_user_permissions_user_id;
DROP INDEX public.auth_user_user_permissions_permission_id;
DROP INDEX public.auth_user_groups_user_id;
DROP INDEX public.auth_user_groups_group_id;
DROP INDEX public.auth_permission_content_type_id;
DROP INDEX public.auth_group_permissions_permission_id;
DROP INDEX public.auth_group_permissions_group_id;
DROP INDEX public.auth_group_name_like;
DROP INDEX public.anuencias_tecnicas_usuario_dependencia_usuario_id;
DROP INDEX public.anuencias_tecnicas_usuario_dependencia_dependencia_id;
DROP INDEX public.anuencias_tecnicas_revision_usuario_id;
DROP INDEX public.anuencias_tecnicas_revision_anuencia_id;
DROP INDEX public.anuencias_tecnicas_perfil_usuario_id;
DROP INDEX public.anuencias_tecnicas_perfil_tipo_id;
DROP INDEX public.anuencias_tecnicas_perfil_direccion_id;
DROP INDEX public.anuencias_tecnicas_estatus_usuario_id;
DROP INDEX public.anuencias_tecnicas_book_author_id;
DROP INDEX public.anuencias_tecnicas_autorizacion_usuario_id;
DROP INDEX public.anuencias_tecnicas_autorizacion_anuencia_id;
DROP INDEX public.anuencias_tecnicas_articulos_usuario_id;
DROP INDEX public.anuencias_tecnicas_articulos_anuencia_id;
DROP INDEX public.anuencias_tecnicas_anuencia_detalle_usuario_id;
DROP INDEX public.anuencias_tecnicas_anuencia_detalle_proyecto_id;
DROP INDEX public.anuencias_tecnicas_anuencia_detalle_partida_id;
DROP INDEX public.anuencias_tecnicas_anuencia_detalle_categoria_id;
DROP INDEX public.anuencias_tecnicas_anuencia_detalle_anuencia_id;
DROP INDEX public.anuencias_tecnicas_anuencia_datos_usuario_id;
DROP INDEX public.anuencias_tecnicas_anuencia_datos_estatus_id;
DROP INDEX public.anuencias_tecnicas_anuencia_datos_dependencias_id;
DROP INDEX public.anuencias_tecnicas_addproyectos_dependencia_id;
DROP INDEX public.anuencias_tecnicas_addpartidas_proyectos_addproyectos_id;
DROP INDEX public.anuencias_tecnicas_addpartidas_proyectos_addpartidas_id;
ALTER TABLE ONLY public.django_site DROP CONSTRAINT django_site_pkey;
ALTER TABLE ONLY public.django_session DROP CONSTRAINT django_session_pkey;
ALTER TABLE ONLY public.django_content_type DROP CONSTRAINT django_content_type_pkey;
ALTER TABLE ONLY public.django_content_type DROP CONSTRAINT django_content_type_app_label_model_key;
ALTER TABLE ONLY public.django_admin_log DROP CONSTRAINT django_admin_log_pkey;
ALTER TABLE ONLY public.dependencias_tipo_usuario DROP CONSTRAINT dependencias_tipo_usuario_pkey;
ALTER TABLE ONLY public.dependencias_perfil DROP CONSTRAINT dependencias_perfil_pkey;
ALTER TABLE ONLY public.dependencias_adscripcion DROP CONSTRAINT dependencias_adscripcion_pkey;
ALTER TABLE ONLY public.auth_user DROP CONSTRAINT auth_user_username_key;
ALTER TABLE ONLY public.auth_user_user_permissions DROP CONSTRAINT auth_user_user_permissions_user_id_permission_id_key;
ALTER TABLE ONLY public.auth_user_user_permissions DROP CONSTRAINT auth_user_user_permissions_pkey;
ALTER TABLE ONLY public.auth_user DROP CONSTRAINT auth_user_pkey;
ALTER TABLE ONLY public.auth_user_groups DROP CONSTRAINT auth_user_groups_user_id_group_id_key;
ALTER TABLE ONLY public.auth_user_groups DROP CONSTRAINT auth_user_groups_pkey;
ALTER TABLE ONLY public.auth_permission DROP CONSTRAINT auth_permission_pkey;
ALTER TABLE ONLY public.auth_permission DROP CONSTRAINT auth_permission_content_type_id_codename_key;
ALTER TABLE ONLY public.auth_group DROP CONSTRAINT auth_group_pkey;
ALTER TABLE ONLY public.auth_group_permissions DROP CONSTRAINT auth_group_permissions_pkey;
ALTER TABLE ONLY public.auth_group_permissions DROP CONSTRAINT auth_group_permissions_group_id_permission_id_key;
ALTER TABLE ONLY public.auth_group DROP CONSTRAINT auth_group_name_key;
ALTER TABLE ONLY public.anuencias_tecnicas_usuario_dependencia DROP CONSTRAINT anuencias_tecnicas_usuario_dependencia_pkey;
ALTER TABLE ONLY public.anuencias_tecnicas_tipo_usuario DROP CONSTRAINT anuencias_tecnicas_tipo_usuario_pkey;
ALTER TABLE ONLY public.anuencias_tecnicas_revision DROP CONSTRAINT anuencias_tecnicas_revision_pkey;
ALTER TABLE ONLY public.anuencias_tecnicas_perfil DROP CONSTRAINT anuencias_tecnicas_perfil_usuario_id_key;
ALTER TABLE ONLY public.anuencias_tecnicas_perfil DROP CONSTRAINT anuencias_tecnicas_perfil_pkey;
ALTER TABLE ONLY public.anuencias_tecnicas_estatus DROP CONSTRAINT anuencias_tecnicas_estatus_pkey;
ALTER TABLE ONLY public.anuencias_tecnicas_categoria DROP CONSTRAINT anuencias_tecnicas_categoria_pkey;
ALTER TABLE ONLY public.anuencias_tecnicas_catalogodependencias DROP CONSTRAINT anuencias_tecnicas_catalogodependencias_pkey;
ALTER TABLE ONLY public.anuencias_tecnicas_book DROP CONSTRAINT anuencias_tecnicas_book_pkey;
ALTER TABLE ONLY public.anuencias_tecnicas_autorizacion DROP CONSTRAINT anuencias_tecnicas_autorizacion_pkey;
ALTER TABLE ONLY public.anuencias_tecnicas_author DROP CONSTRAINT anuencias_tecnicas_author_pkey;
ALTER TABLE ONLY public.anuencias_tecnicas_articulos DROP CONSTRAINT anuencias_tecnicas_articulos_pkey;
ALTER TABLE ONLY public.anuencias_tecnicas_anuencia_detalle DROP CONSTRAINT anuencias_tecnicas_anuencia_detalle_pkey;
ALTER TABLE ONLY public.anuencias_tecnicas_anuencia_datos DROP CONSTRAINT anuencias_tecnicas_anuencia_datos_pkey;
ALTER TABLE ONLY public.anuencias_tecnicas_addproyectos DROP CONSTRAINT anuencias_tecnicas_addproyectos_pkey;
ALTER TABLE ONLY public.anuencias_tecnicas_addpartidas_proyectos DROP CONSTRAINT anuencias_tecnicas_addpartidas_proyectos_pkey;
ALTER TABLE ONLY public.anuencias_tecnicas_addpartidas_proyectos DROP CONSTRAINT anuencias_tecnicas_addpartidas_proyectos_addpartidas_id_key;
ALTER TABLE ONLY public.anuencias_tecnicas_addpartidas DROP CONSTRAINT anuencias_tecnicas_addpartidas_pkey;
ALTER TABLE public.django_site ALTER COLUMN id DROP DEFAULT;
ALTER TABLE public.django_content_type ALTER COLUMN id DROP DEFAULT;
ALTER TABLE public.django_admin_log ALTER COLUMN id DROP DEFAULT;
ALTER TABLE public.dependencias_tipo_usuario ALTER COLUMN id DROP DEFAULT;
ALTER TABLE public.dependencias_perfil ALTER COLUMN id DROP DEFAULT;
ALTER TABLE public.dependencias_adscripcion ALTER COLUMN id DROP DEFAULT;
ALTER TABLE public.auth_user_user_permissions ALTER COLUMN id DROP DEFAULT;
ALTER TABLE public.auth_user_groups ALTER COLUMN id DROP DEFAULT;
ALTER TABLE public.auth_user ALTER COLUMN id DROP DEFAULT;
ALTER TABLE public.auth_permission ALTER COLUMN id DROP DEFAULT;
ALTER TABLE public.auth_group_permissions ALTER COLUMN id DROP DEFAULT;
ALTER TABLE public.auth_group ALTER COLUMN id DROP DEFAULT;
ALTER TABLE public.anuencias_tecnicas_usuario_dependencia ALTER COLUMN id DROP DEFAULT;
ALTER TABLE public.anuencias_tecnicas_tipo_usuario ALTER COLUMN id DROP DEFAULT;
ALTER TABLE public.anuencias_tecnicas_revision ALTER COLUMN id DROP DEFAULT;
ALTER TABLE public.anuencias_tecnicas_perfil ALTER COLUMN id DROP DEFAULT;
ALTER TABLE public.anuencias_tecnicas_estatus ALTER COLUMN id DROP DEFAULT;
ALTER TABLE public.anuencias_tecnicas_categoria ALTER COLUMN id DROP DEFAULT;
ALTER TABLE public.anuencias_tecnicas_catalogodependencias ALTER COLUMN id DROP DEFAULT;
ALTER TABLE public.anuencias_tecnicas_book ALTER COLUMN id DROP DEFAULT;
ALTER TABLE public.anuencias_tecnicas_autorizacion ALTER COLUMN id DROP DEFAULT;
ALTER TABLE public.anuencias_tecnicas_author ALTER COLUMN id DROP DEFAULT;
ALTER TABLE public.anuencias_tecnicas_articulos ALTER COLUMN id DROP DEFAULT;
ALTER TABLE public.anuencias_tecnicas_anuencia_detalle ALTER COLUMN id DROP DEFAULT;
ALTER TABLE public.anuencias_tecnicas_anuencia_datos ALTER COLUMN id DROP DEFAULT;
ALTER TABLE public.anuencias_tecnicas_addproyectos ALTER COLUMN id DROP DEFAULT;
ALTER TABLE public.anuencias_tecnicas_addpartidas_proyectos ALTER COLUMN id DROP DEFAULT;
ALTER TABLE public.anuencias_tecnicas_addpartidas ALTER COLUMN id DROP DEFAULT;
DROP SEQUENCE public.django_site_id_seq;
DROP TABLE public.django_site;
DROP TABLE public.django_session;
DROP SEQUENCE public.django_content_type_id_seq;
DROP TABLE public.django_content_type;
DROP SEQUENCE public.django_admin_log_id_seq;
DROP TABLE public.django_admin_log;
DROP SEQUENCE public.dependencias_tipo_usuario_id_seq;
DROP TABLE public.dependencias_tipo_usuario;
DROP SEQUENCE public.dependencias_perfil_id_seq;
DROP TABLE public.dependencias_perfil;
DROP SEQUENCE public.dependencias_adscripcion_id_seq;
DROP TABLE public.dependencias_adscripcion;
DROP SEQUENCE public.auth_user_user_permissions_id_seq;
DROP TABLE public.auth_user_user_permissions;
DROP SEQUENCE public.auth_user_id_seq;
DROP SEQUENCE public.auth_user_groups_id_seq;
DROP TABLE public.auth_user_groups;
DROP TABLE public.auth_user;
DROP SEQUENCE public.auth_permission_id_seq;
DROP TABLE public.auth_permission;
DROP SEQUENCE public.auth_group_permissions_id_seq;
DROP TABLE public.auth_group_permissions;
DROP SEQUENCE public.auth_group_id_seq;
DROP TABLE public.auth_group;
DROP SEQUENCE public.anuencias_tecnicas_usuario_dependencia_id_seq;
DROP TABLE public.anuencias_tecnicas_usuario_dependencia;
DROP SEQUENCE public.anuencias_tecnicas_tipo_usuario_id_seq;
DROP TABLE public.anuencias_tecnicas_tipo_usuario;
DROP SEQUENCE public.anuencias_tecnicas_revision_id_seq;
DROP TABLE public.anuencias_tecnicas_revision;
DROP SEQUENCE public.anuencias_tecnicas_perfil_id_seq;
DROP TABLE public.anuencias_tecnicas_perfil;
DROP SEQUENCE public.anuencias_tecnicas_estatus_id_seq;
DROP TABLE public.anuencias_tecnicas_estatus;
DROP SEQUENCE public.anuencias_tecnicas_categoria_id_seq;
DROP TABLE public.anuencias_tecnicas_categoria;
DROP SEQUENCE public.anuencias_tecnicas_catalogodependencias_id_seq;
DROP TABLE public.anuencias_tecnicas_catalogodependencias;
DROP SEQUENCE public.anuencias_tecnicas_book_id_seq;
DROP TABLE public.anuencias_tecnicas_book;
DROP SEQUENCE public.anuencias_tecnicas_autorizacion_id_seq;
DROP TABLE public.anuencias_tecnicas_autorizacion;
DROP SEQUENCE public.anuencias_tecnicas_author_id_seq;
DROP TABLE public.anuencias_tecnicas_author;
DROP SEQUENCE public.anuencias_tecnicas_articulos_id_seq;
DROP TABLE public.anuencias_tecnicas_articulos;
DROP SEQUENCE public.anuencias_tecnicas_anuencia_detalle_id_seq;
DROP TABLE public.anuencias_tecnicas_anuencia_detalle;
DROP SEQUENCE public.anuencias_tecnicas_anuencia_datos_id_seq;
DROP TABLE public.anuencias_tecnicas_anuencia_datos;
DROP SEQUENCE public.anuencias_tecnicas_addproyectos_id_seq;
DROP TABLE public.anuencias_tecnicas_addproyectos;
DROP SEQUENCE public.anuencias_tecnicas_addpartidas_proyectos_id_seq;
DROP TABLE public.anuencias_tecnicas_addpartidas_proyectos;
DROP SEQUENCE public.anuencias_tecnicas_addpartidas_id_seq;
DROP TABLE public.anuencias_tecnicas_addpartidas;
DROP SCHEMA public;
--
-- Name: public; Type: SCHEMA; Schema: -; Owner: postgres
--

CREATE SCHEMA public;


ALTER SCHEMA public OWNER TO postgres;

--
-- Name: SCHEMA public; Type: COMMENT; Schema: -; Owner: postgres
--

COMMENT ON SCHEMA public IS 'standard public schema';


SET search_path = public, pg_catalog;

SET default_tablespace = '';

SET default_with_oids = false;

--
-- Name: anuencias_tecnicas_addpartidas; Type: TABLE; Schema: public; Owner: Produccion; Tablespace: 
--

CREATE TABLE anuencias_tecnicas_addpartidas (
    id integer NOT NULL,
    clave character varying(100) NOT NULL,
    nombre character varying(200) NOT NULL
);


ALTER TABLE public.anuencias_tecnicas_addpartidas OWNER TO "Produccion";

--
-- Name: anuencias_tecnicas_addpartidas_id_seq; Type: SEQUENCE; Schema: public; Owner: Produccion
--

CREATE SEQUENCE anuencias_tecnicas_addpartidas_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.anuencias_tecnicas_addpartidas_id_seq OWNER TO "Produccion";

--
-- Name: anuencias_tecnicas_addpartidas_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: Produccion
--

ALTER SEQUENCE anuencias_tecnicas_addpartidas_id_seq OWNED BY anuencias_tecnicas_addpartidas.id;


--
-- Name: anuencias_tecnicas_addpartidas_proyectos; Type: TABLE; Schema: public; Owner: Produccion; Tablespace: 
--

CREATE TABLE anuencias_tecnicas_addpartidas_proyectos (
    id integer NOT NULL,
    addpartidas_id integer NOT NULL,
    addproyectos_id integer NOT NULL
);


ALTER TABLE public.anuencias_tecnicas_addpartidas_proyectos OWNER TO "Produccion";

--
-- Name: anuencias_tecnicas_addpartidas_proyectos_id_seq; Type: SEQUENCE; Schema: public; Owner: Produccion
--

CREATE SEQUENCE anuencias_tecnicas_addpartidas_proyectos_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.anuencias_tecnicas_addpartidas_proyectos_id_seq OWNER TO "Produccion";

--
-- Name: anuencias_tecnicas_addpartidas_proyectos_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: Produccion
--

ALTER SEQUENCE anuencias_tecnicas_addpartidas_proyectos_id_seq OWNED BY anuencias_tecnicas_addpartidas_proyectos.id;


--
-- Name: anuencias_tecnicas_addproyectos; Type: TABLE; Schema: public; Owner: Produccion; Tablespace: 
--

CREATE TABLE anuencias_tecnicas_addproyectos (
    id integer NOT NULL,
    dependencia_id integer NOT NULL,
    clave character varying(100) NOT NULL,
    nombre character varying(800) NOT NULL
);


ALTER TABLE public.anuencias_tecnicas_addproyectos OWNER TO "Produccion";

--
-- Name: anuencias_tecnicas_addproyectos_id_seq; Type: SEQUENCE; Schema: public; Owner: Produccion
--

CREATE SEQUENCE anuencias_tecnicas_addproyectos_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.anuencias_tecnicas_addproyectos_id_seq OWNER TO "Produccion";

--
-- Name: anuencias_tecnicas_addproyectos_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: Produccion
--

ALTER SEQUENCE anuencias_tecnicas_addproyectos_id_seq OWNED BY anuencias_tecnicas_addproyectos.id;


--
-- Name: anuencias_tecnicas_anuencia_datos; Type: TABLE; Schema: public; Owner: Produccion; Tablespace: 
--

CREATE TABLE anuencias_tecnicas_anuencia_datos (
    id integer NOT NULL,
    fecha_registro date NOT NULL,
    fecha_ultimo_cambio timestamp with time zone NOT NULL,
    activo boolean NOT NULL,
    usuario_id integer NOT NULL,
    fecha_solicitud date,
    fecha_recepcion timestamp with time zone,
    dependencias_id integer NOT NULL,
    no_oficio character varying(120) NOT NULL,
    contacto_tecnico character varying(150) NOT NULL,
    telefono_fax character varying(15) NOT NULL,
    extension character varying(6),
    correo_electronico character varying(150),
    no_requisicion character varying(15),
    estatus_id integer NOT NULL,
    autorizacion_presupuesto character varying(100),
    autorizacion_tecnica character varying(100),
    cotizaciones character varying(100),
    justificacion text NOT NULL,
    puesto_responsable character varying(150),
    oficio_dgtic character varying(20),
    rstatus character(12)
);


ALTER TABLE public.anuencias_tecnicas_anuencia_datos OWNER TO "Produccion";

--
-- Name: anuencias_tecnicas_anuencia_datos_id_seq; Type: SEQUENCE; Schema: public; Owner: Produccion
--

CREATE SEQUENCE anuencias_tecnicas_anuencia_datos_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.anuencias_tecnicas_anuencia_datos_id_seq OWNER TO "Produccion";

--
-- Name: anuencias_tecnicas_anuencia_datos_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: Produccion
--

ALTER SEQUENCE anuencias_tecnicas_anuencia_datos_id_seq OWNED BY anuencias_tecnicas_anuencia_datos.id;


--
-- Name: anuencias_tecnicas_anuencia_detalle; Type: TABLE; Schema: public; Owner: Produccion; Tablespace: 
--

CREATE TABLE anuencias_tecnicas_anuencia_detalle (
    id integer NOT NULL,
    fecha_registro date NOT NULL,
    fecha_ultimo_cambio timestamp with time zone NOT NULL,
    activo boolean NOT NULL,
    usuario_id integer NOT NULL,
    anuencia_id integer NOT NULL,
    proyecto_id integer NOT NULL,
    partida_id integer NOT NULL,
    no_lote character varying(3),
    articulo character varying(300) NOT NULL,
    categoria_id integer NOT NULL,
    descripcion text NOT NULL,
    cantidad integer NOT NULL,
    precio numeric(20,2) NOT NULL,
    iva integer NOT NULL,
    total numeric(20,2) NOT NULL,
    url character varying(200),
    autorizado boolean NOT NULL,
    observaciones text
);


ALTER TABLE public.anuencias_tecnicas_anuencia_detalle OWNER TO "Produccion";

--
-- Name: anuencias_tecnicas_anuencia_detalle_id_seq; Type: SEQUENCE; Schema: public; Owner: Produccion
--

CREATE SEQUENCE anuencias_tecnicas_anuencia_detalle_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.anuencias_tecnicas_anuencia_detalle_id_seq OWNER TO "Produccion";

--
-- Name: anuencias_tecnicas_anuencia_detalle_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: Produccion
--

ALTER SEQUENCE anuencias_tecnicas_anuencia_detalle_id_seq OWNED BY anuencias_tecnicas_anuencia_detalle.id;


--
-- Name: anuencias_tecnicas_articulos; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE anuencias_tecnicas_articulos (
    id integer NOT NULL,
    fecha_registro timestamp with time zone NOT NULL,
    fecha_ultimo_cambio timestamp with time zone NOT NULL,
    activo boolean NOT NULL,
    usuario_id integer NOT NULL,
    anuencia_id integer NOT NULL,
    articulo character varying(300) NOT NULL,
    descripcion text NOT NULL,
    cantidad integer NOT NULL,
    precio numeric(7,2) NOT NULL,
    url character varying(200) NOT NULL,
    autorizado boolean NOT NULL,
    no_lote character varying(15) NOT NULL,
    observaciones text
);


ALTER TABLE public.anuencias_tecnicas_articulos OWNER TO postgres;

--
-- Name: anuencias_tecnicas_articulos_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE anuencias_tecnicas_articulos_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.anuencias_tecnicas_articulos_id_seq OWNER TO postgres;

--
-- Name: anuencias_tecnicas_articulos_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE anuencias_tecnicas_articulos_id_seq OWNED BY anuencias_tecnicas_articulos.id;


--
-- Name: anuencias_tecnicas_author; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE anuencias_tecnicas_author (
    id integer NOT NULL,
    name character varying(100) NOT NULL
);


ALTER TABLE public.anuencias_tecnicas_author OWNER TO postgres;

--
-- Name: anuencias_tecnicas_author_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE anuencias_tecnicas_author_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.anuencias_tecnicas_author_id_seq OWNER TO postgres;

--
-- Name: anuencias_tecnicas_author_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE anuencias_tecnicas_author_id_seq OWNED BY anuencias_tecnicas_author.id;


--
-- Name: anuencias_tecnicas_autorizacion; Type: TABLE; Schema: public; Owner: Produccion; Tablespace: 
--

CREATE TABLE anuencias_tecnicas_autorizacion (
    id integer NOT NULL,
    fecha_registro timestamp with time zone NOT NULL,
    fecha_ultimo_cambio timestamp with time zone NOT NULL,
    activo boolean NOT NULL,
    usuario_id integer NOT NULL,
    anuencia_id integer NOT NULL
);


ALTER TABLE public.anuencias_tecnicas_autorizacion OWNER TO "Produccion";

--
-- Name: anuencias_tecnicas_autorizacion_id_seq; Type: SEQUENCE; Schema: public; Owner: Produccion
--

CREATE SEQUENCE anuencias_tecnicas_autorizacion_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.anuencias_tecnicas_autorizacion_id_seq OWNER TO "Produccion";

--
-- Name: anuencias_tecnicas_autorizacion_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: Produccion
--

ALTER SEQUENCE anuencias_tecnicas_autorizacion_id_seq OWNED BY anuencias_tecnicas_autorizacion.id;


--
-- Name: anuencias_tecnicas_book; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE anuencias_tecnicas_book (
    id integer NOT NULL,
    author_id integer NOT NULL,
    title character varying(100) NOT NULL
);


ALTER TABLE public.anuencias_tecnicas_book OWNER TO postgres;

--
-- Name: anuencias_tecnicas_book_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE anuencias_tecnicas_book_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.anuencias_tecnicas_book_id_seq OWNER TO postgres;

--
-- Name: anuencias_tecnicas_book_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE anuencias_tecnicas_book_id_seq OWNED BY anuencias_tecnicas_book.id;


--
-- Name: anuencias_tecnicas_catalogodependencias; Type: TABLE; Schema: public; Owner: Produccion; Tablespace: 
--

CREATE TABLE anuencias_tecnicas_catalogodependencias (
    id integer NOT NULL,
    clave character varying(150) NOT NULL,
    nombre character varying(150) NOT NULL,
    ejercicio integer NOT NULL
);


ALTER TABLE public.anuencias_tecnicas_catalogodependencias OWNER TO "Produccion";

--
-- Name: anuencias_tecnicas_catalogodependencias_id_seq; Type: SEQUENCE; Schema: public; Owner: Produccion
--

CREATE SEQUENCE anuencias_tecnicas_catalogodependencias_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.anuencias_tecnicas_catalogodependencias_id_seq OWNER TO "Produccion";

--
-- Name: anuencias_tecnicas_catalogodependencias_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: Produccion
--

ALTER SEQUENCE anuencias_tecnicas_catalogodependencias_id_seq OWNED BY anuencias_tecnicas_catalogodependencias.id;


--
-- Name: anuencias_tecnicas_categoria; Type: TABLE; Schema: public; Owner: Produccion; Tablespace: 
--

CREATE TABLE anuencias_tecnicas_categoria (
    id integer NOT NULL,
    clave character varying(100) NOT NULL,
    descripcion character varying(500) NOT NULL
);


ALTER TABLE public.anuencias_tecnicas_categoria OWNER TO "Produccion";

--
-- Name: anuencias_tecnicas_categoria_id_seq; Type: SEQUENCE; Schema: public; Owner: Produccion
--

CREATE SEQUENCE anuencias_tecnicas_categoria_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.anuencias_tecnicas_categoria_id_seq OWNER TO "Produccion";

--
-- Name: anuencias_tecnicas_categoria_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: Produccion
--

ALTER SEQUENCE anuencias_tecnicas_categoria_id_seq OWNED BY anuencias_tecnicas_categoria.id;


--
-- Name: anuencias_tecnicas_estatus; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE anuencias_tecnicas_estatus (
    id integer NOT NULL,
    fecha_registro timestamp with time zone NOT NULL,
    fecha_ultimo_cambio timestamp with time zone NOT NULL,
    activo boolean NOT NULL,
    usuario_id integer NOT NULL,
    clave character varying(10) NOT NULL,
    nombre character varying(150) NOT NULL,
    descripcion text NOT NULL,
    color character varying(17) NOT NULL,
    secuencia integer
);


ALTER TABLE public.anuencias_tecnicas_estatus OWNER TO postgres;

--
-- Name: anuencias_tecnicas_estatus_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE anuencias_tecnicas_estatus_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.anuencias_tecnicas_estatus_id_seq OWNER TO postgres;

--
-- Name: anuencias_tecnicas_estatus_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE anuencias_tecnicas_estatus_id_seq OWNED BY anuencias_tecnicas_estatus.id;


--
-- Name: anuencias_tecnicas_perfil; Type: TABLE; Schema: public; Owner: Produccion; Tablespace: 
--

CREATE TABLE anuencias_tecnicas_perfil (
    id integer NOT NULL,
    tipo_id integer NOT NULL,
    usuario_id integer NOT NULL,
    direccion_id integer NOT NULL
);


ALTER TABLE public.anuencias_tecnicas_perfil OWNER TO "Produccion";

--
-- Name: anuencias_tecnicas_perfil_id_seq; Type: SEQUENCE; Schema: public; Owner: Produccion
--

CREATE SEQUENCE anuencias_tecnicas_perfil_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.anuencias_tecnicas_perfil_id_seq OWNER TO "Produccion";

--
-- Name: anuencias_tecnicas_perfil_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: Produccion
--

ALTER SEQUENCE anuencias_tecnicas_perfil_id_seq OWNED BY anuencias_tecnicas_perfil.id;


--
-- Name: anuencias_tecnicas_revision; Type: TABLE; Schema: public; Owner: Produccion; Tablespace: 
--

CREATE TABLE anuencias_tecnicas_revision (
    id integer NOT NULL,
    fecha_registro timestamp with time zone NOT NULL,
    fecha_ultimo_cambio timestamp with time zone NOT NULL,
    activo boolean NOT NULL,
    usuario_id integer NOT NULL,
    anuencia_id integer NOT NULL
);


ALTER TABLE public.anuencias_tecnicas_revision OWNER TO "Produccion";

--
-- Name: anuencias_tecnicas_revision_id_seq; Type: SEQUENCE; Schema: public; Owner: Produccion
--

CREATE SEQUENCE anuencias_tecnicas_revision_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.anuencias_tecnicas_revision_id_seq OWNER TO "Produccion";

--
-- Name: anuencias_tecnicas_revision_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: Produccion
--

ALTER SEQUENCE anuencias_tecnicas_revision_id_seq OWNED BY anuencias_tecnicas_revision.id;


--
-- Name: anuencias_tecnicas_tipo_usuario; Type: TABLE; Schema: public; Owner: Produccion; Tablespace: 
--

CREATE TABLE anuencias_tecnicas_tipo_usuario (
    id integer NOT NULL,
    clave character varying(10) NOT NULL,
    nombre character varying(50) NOT NULL
);


ALTER TABLE public.anuencias_tecnicas_tipo_usuario OWNER TO "Produccion";

--
-- Name: anuencias_tecnicas_tipo_usuario_id_seq; Type: SEQUENCE; Schema: public; Owner: Produccion
--

CREATE SEQUENCE anuencias_tecnicas_tipo_usuario_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.anuencias_tecnicas_tipo_usuario_id_seq OWNER TO "Produccion";

--
-- Name: anuencias_tecnicas_tipo_usuario_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: Produccion
--

ALTER SEQUENCE anuencias_tecnicas_tipo_usuario_id_seq OWNED BY anuencias_tecnicas_tipo_usuario.id;


--
-- Name: anuencias_tecnicas_usuario_dependencia; Type: TABLE; Schema: public; Owner: Produccion; Tablespace: 
--

CREATE TABLE anuencias_tecnicas_usuario_dependencia (
    id integer NOT NULL,
    usuario_id integer NOT NULL,
    dependencia_id integer NOT NULL
);


ALTER TABLE public.anuencias_tecnicas_usuario_dependencia OWNER TO "Produccion";

--
-- Name: anuencias_tecnicas_usuario_dependencia_id_seq; Type: SEQUENCE; Schema: public; Owner: Produccion
--

CREATE SEQUENCE anuencias_tecnicas_usuario_dependencia_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.anuencias_tecnicas_usuario_dependencia_id_seq OWNER TO "Produccion";

--
-- Name: anuencias_tecnicas_usuario_dependencia_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: Produccion
--

ALTER SEQUENCE anuencias_tecnicas_usuario_dependencia_id_seq OWNED BY anuencias_tecnicas_usuario_dependencia.id;


--
-- Name: auth_group; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE auth_group (
    id integer NOT NULL,
    name character varying(80) NOT NULL
);


ALTER TABLE public.auth_group OWNER TO postgres;

--
-- Name: auth_group_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE auth_group_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.auth_group_id_seq OWNER TO postgres;

--
-- Name: auth_group_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE auth_group_id_seq OWNED BY auth_group.id;


--
-- Name: auth_group_permissions; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE auth_group_permissions (
    id integer NOT NULL,
    group_id integer NOT NULL,
    permission_id integer NOT NULL
);


ALTER TABLE public.auth_group_permissions OWNER TO postgres;

--
-- Name: auth_group_permissions_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE auth_group_permissions_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.auth_group_permissions_id_seq OWNER TO postgres;

--
-- Name: auth_group_permissions_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE auth_group_permissions_id_seq OWNED BY auth_group_permissions.id;


--
-- Name: auth_permission; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE auth_permission (
    id integer NOT NULL,
    name character varying(50) NOT NULL,
    content_type_id integer NOT NULL,
    codename character varying(100) NOT NULL
);


ALTER TABLE public.auth_permission OWNER TO postgres;

--
-- Name: auth_permission_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE auth_permission_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.auth_permission_id_seq OWNER TO postgres;

--
-- Name: auth_permission_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE auth_permission_id_seq OWNED BY auth_permission.id;


--
-- Name: auth_user; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE auth_user (
    id integer NOT NULL,
    password character varying(128) NOT NULL,
    last_login timestamp with time zone NOT NULL,
    is_superuser boolean NOT NULL,
    username character varying(30) NOT NULL,
    first_name character varying(30) NOT NULL,
    last_name character varying(30) NOT NULL,
    email character varying(75) NOT NULL,
    is_staff boolean NOT NULL,
    is_active boolean NOT NULL,
    date_joined timestamp with time zone NOT NULL
);


ALTER TABLE public.auth_user OWNER TO postgres;

--
-- Name: auth_user_groups; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE auth_user_groups (
    id integer NOT NULL,
    user_id integer NOT NULL,
    group_id integer NOT NULL
);


ALTER TABLE public.auth_user_groups OWNER TO postgres;

--
-- Name: auth_user_groups_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE auth_user_groups_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.auth_user_groups_id_seq OWNER TO postgres;

--
-- Name: auth_user_groups_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE auth_user_groups_id_seq OWNED BY auth_user_groups.id;


--
-- Name: auth_user_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE auth_user_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.auth_user_id_seq OWNER TO postgres;

--
-- Name: auth_user_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE auth_user_id_seq OWNED BY auth_user.id;


--
-- Name: auth_user_user_permissions; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE auth_user_user_permissions (
    id integer NOT NULL,
    user_id integer NOT NULL,
    permission_id integer NOT NULL
);


ALTER TABLE public.auth_user_user_permissions OWNER TO postgres;

--
-- Name: auth_user_user_permissions_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE auth_user_user_permissions_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.auth_user_user_permissions_id_seq OWNER TO postgres;

--
-- Name: auth_user_user_permissions_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE auth_user_user_permissions_id_seq OWNED BY auth_user_user_permissions.id;


--
-- Name: dependencias_adscripcion; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE dependencias_adscripcion (
    id integer NOT NULL,
    adscripcion_padre_id integer,
    nombre character varying(150) NOT NULL,
    siglas character varying(10) NOT NULL,
    logo character varying(100),
    activo boolean NOT NULL,
    fecha_baja timestamp with time zone,
    fecha_alta timestamp with time zone NOT NULL
);


ALTER TABLE public.dependencias_adscripcion OWNER TO postgres;

--
-- Name: dependencias_adscripcion_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE dependencias_adscripcion_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.dependencias_adscripcion_id_seq OWNER TO postgres;

--
-- Name: dependencias_adscripcion_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE dependencias_adscripcion_id_seq OWNED BY dependencias_adscripcion.id;


--
-- Name: dependencias_perfil; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE dependencias_perfil (
    id integer NOT NULL,
    tipo_id integer NOT NULL,
    usuario_id integer NOT NULL,
    direccion_id integer
);


ALTER TABLE public.dependencias_perfil OWNER TO postgres;

--
-- Name: dependencias_perfil_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE dependencias_perfil_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.dependencias_perfil_id_seq OWNER TO postgres;

--
-- Name: dependencias_perfil_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE dependencias_perfil_id_seq OWNED BY dependencias_perfil.id;


--
-- Name: dependencias_tipo_usuario; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE dependencias_tipo_usuario (
    id integer NOT NULL,
    clave character varying(10) NOT NULL,
    nombre character varying(50) NOT NULL
);


ALTER TABLE public.dependencias_tipo_usuario OWNER TO postgres;

--
-- Name: dependencias_tipo_usuario_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE dependencias_tipo_usuario_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.dependencias_tipo_usuario_id_seq OWNER TO postgres;

--
-- Name: dependencias_tipo_usuario_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE dependencias_tipo_usuario_id_seq OWNED BY dependencias_tipo_usuario.id;


--
-- Name: django_admin_log; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE django_admin_log (
    id integer NOT NULL,
    action_time timestamp with time zone NOT NULL,
    user_id integer NOT NULL,
    content_type_id integer,
    object_id text,
    object_repr character varying(200) NOT NULL,
    action_flag smallint NOT NULL,
    change_message text NOT NULL,
    CONSTRAINT django_admin_log_action_flag_check CHECK ((action_flag >= 0))
);


ALTER TABLE public.django_admin_log OWNER TO postgres;

--
-- Name: django_admin_log_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE django_admin_log_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.django_admin_log_id_seq OWNER TO postgres;

--
-- Name: django_admin_log_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE django_admin_log_id_seq OWNED BY django_admin_log.id;


--
-- Name: django_content_type; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE django_content_type (
    id integer NOT NULL,
    name character varying(100) NOT NULL,
    app_label character varying(100) NOT NULL,
    model character varying(100) NOT NULL
);


ALTER TABLE public.django_content_type OWNER TO postgres;

--
-- Name: django_content_type_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE django_content_type_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.django_content_type_id_seq OWNER TO postgres;

--
-- Name: django_content_type_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE django_content_type_id_seq OWNED BY django_content_type.id;


--
-- Name: django_session; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE django_session (
    session_key character varying(40) NOT NULL,
    session_data text NOT NULL,
    expire_date timestamp with time zone NOT NULL
);


ALTER TABLE public.django_session OWNER TO postgres;

--
-- Name: django_site; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE django_site (
    id integer NOT NULL,
    domain character varying(100) NOT NULL,
    name character varying(50) NOT NULL
);


ALTER TABLE public.django_site OWNER TO postgres;

--
-- Name: django_site_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE django_site_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.django_site_id_seq OWNER TO postgres;

--
-- Name: django_site_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE django_site_id_seq OWNED BY django_site.id;


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: Produccion
--

ALTER TABLE ONLY anuencias_tecnicas_addpartidas ALTER COLUMN id SET DEFAULT nextval('anuencias_tecnicas_addpartidas_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: Produccion
--

ALTER TABLE ONLY anuencias_tecnicas_addpartidas_proyectos ALTER COLUMN id SET DEFAULT nextval('anuencias_tecnicas_addpartidas_proyectos_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: Produccion
--

ALTER TABLE ONLY anuencias_tecnicas_addproyectos ALTER COLUMN id SET DEFAULT nextval('anuencias_tecnicas_addproyectos_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: Produccion
--

ALTER TABLE ONLY anuencias_tecnicas_anuencia_datos ALTER COLUMN id SET DEFAULT nextval('anuencias_tecnicas_anuencia_datos_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: Produccion
--

ALTER TABLE ONLY anuencias_tecnicas_anuencia_detalle ALTER COLUMN id SET DEFAULT nextval('anuencias_tecnicas_anuencia_detalle_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY anuencias_tecnicas_articulos ALTER COLUMN id SET DEFAULT nextval('anuencias_tecnicas_articulos_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY anuencias_tecnicas_author ALTER COLUMN id SET DEFAULT nextval('anuencias_tecnicas_author_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: Produccion
--

ALTER TABLE ONLY anuencias_tecnicas_autorizacion ALTER COLUMN id SET DEFAULT nextval('anuencias_tecnicas_autorizacion_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY anuencias_tecnicas_book ALTER COLUMN id SET DEFAULT nextval('anuencias_tecnicas_book_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: Produccion
--

ALTER TABLE ONLY anuencias_tecnicas_catalogodependencias ALTER COLUMN id SET DEFAULT nextval('anuencias_tecnicas_catalogodependencias_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: Produccion
--

ALTER TABLE ONLY anuencias_tecnicas_categoria ALTER COLUMN id SET DEFAULT nextval('anuencias_tecnicas_categoria_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY anuencias_tecnicas_estatus ALTER COLUMN id SET DEFAULT nextval('anuencias_tecnicas_estatus_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: Produccion
--

ALTER TABLE ONLY anuencias_tecnicas_perfil ALTER COLUMN id SET DEFAULT nextval('anuencias_tecnicas_perfil_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: Produccion
--

ALTER TABLE ONLY anuencias_tecnicas_revision ALTER COLUMN id SET DEFAULT nextval('anuencias_tecnicas_revision_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: Produccion
--

ALTER TABLE ONLY anuencias_tecnicas_tipo_usuario ALTER COLUMN id SET DEFAULT nextval('anuencias_tecnicas_tipo_usuario_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: Produccion
--

ALTER TABLE ONLY anuencias_tecnicas_usuario_dependencia ALTER COLUMN id SET DEFAULT nextval('anuencias_tecnicas_usuario_dependencia_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY auth_group ALTER COLUMN id SET DEFAULT nextval('auth_group_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY auth_group_permissions ALTER COLUMN id SET DEFAULT nextval('auth_group_permissions_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY auth_permission ALTER COLUMN id SET DEFAULT nextval('auth_permission_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY auth_user ALTER COLUMN id SET DEFAULT nextval('auth_user_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY auth_user_groups ALTER COLUMN id SET DEFAULT nextval('auth_user_groups_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY auth_user_user_permissions ALTER COLUMN id SET DEFAULT nextval('auth_user_user_permissions_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY dependencias_adscripcion ALTER COLUMN id SET DEFAULT nextval('dependencias_adscripcion_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY dependencias_perfil ALTER COLUMN id SET DEFAULT nextval('dependencias_perfil_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY dependencias_tipo_usuario ALTER COLUMN id SET DEFAULT nextval('dependencias_tipo_usuario_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY django_admin_log ALTER COLUMN id SET DEFAULT nextval('django_admin_log_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY django_content_type ALTER COLUMN id SET DEFAULT nextval('django_content_type_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY django_site ALTER COLUMN id SET DEFAULT nextval('django_site_id_seq'::regclass);


--
-- Data for Name: anuencias_tecnicas_addpartidas; Type: TABLE DATA; Schema: public; Owner: Produccion
--

COPY anuencias_tecnicas_addpartidas (id, clave, nombre) FROM stdin;
\.
COPY anuencias_tecnicas_addpartidas (id, clave, nombre) FROM '$$PATH$$/2125.dat';

--
-- Name: anuencias_tecnicas_addpartidas_id_seq; Type: SEQUENCE SET; Schema: public; Owner: Produccion
--

SELECT pg_catalog.setval('anuencias_tecnicas_addpartidas_id_seq', 1059, true);


--
-- Data for Name: anuencias_tecnicas_addpartidas_proyectos; Type: TABLE DATA; Schema: public; Owner: Produccion
--

COPY anuencias_tecnicas_addpartidas_proyectos (id, addpartidas_id, addproyectos_id) FROM stdin;
\.
COPY anuencias_tecnicas_addpartidas_proyectos (id, addpartidas_id, addproyectos_id) FROM '$$PATH$$/2127.dat';

--
-- Name: anuencias_tecnicas_addpartidas_proyectos_id_seq; Type: SEQUENCE SET; Schema: public; Owner: Produccion
--

SELECT pg_catalog.setval('anuencias_tecnicas_addpartidas_proyectos_id_seq', 21226, true);


--
-- Data for Name: anuencias_tecnicas_addproyectos; Type: TABLE DATA; Schema: public; Owner: Produccion
--

COPY anuencias_tecnicas_addproyectos (id, dependencia_id, clave, nombre) FROM stdin;
\.
COPY anuencias_tecnicas_addproyectos (id, dependencia_id, clave, nombre) FROM '$$PATH$$/2129.dat';

--
-- Name: anuencias_tecnicas_addproyectos_id_seq; Type: SEQUENCE SET; Schema: public; Owner: Produccion
--

SELECT pg_catalog.setval('anuencias_tecnicas_addproyectos_id_seq', 2315, true);


--
-- Data for Name: anuencias_tecnicas_anuencia_datos; Type: TABLE DATA; Schema: public; Owner: Produccion
--

COPY anuencias_tecnicas_anuencia_datos (id, fecha_registro, fecha_ultimo_cambio, activo, usuario_id, fecha_solicitud, fecha_recepcion, dependencias_id, no_oficio, contacto_tecnico, telefono_fax, extension, correo_electronico, no_requisicion, estatus_id, autorizacion_presupuesto, autorizacion_tecnica, cotizaciones, justificacion, puesto_responsable, oficio_dgtic, rstatus) FROM stdin;
\.
COPY anuencias_tecnicas_anuencia_datos (id, fecha_registro, fecha_ultimo_cambio, activo, usuario_id, fecha_solicitud, fecha_recepcion, dependencias_id, no_oficio, contacto_tecnico, telefono_fax, extension, correo_electronico, no_requisicion, estatus_id, autorizacion_presupuesto, autorizacion_tecnica, cotizaciones, justificacion, puesto_responsable, oficio_dgtic, rstatus) FROM '$$PATH$$/2131.dat';

--
-- Name: anuencias_tecnicas_anuencia_datos_id_seq; Type: SEQUENCE SET; Schema: public; Owner: Produccion
--

SELECT pg_catalog.setval('anuencias_tecnicas_anuencia_datos_id_seq', 750, true);


--
-- Data for Name: anuencias_tecnicas_anuencia_detalle; Type: TABLE DATA; Schema: public; Owner: Produccion
--

COPY anuencias_tecnicas_anuencia_detalle (id, fecha_registro, fecha_ultimo_cambio, activo, usuario_id, anuencia_id, proyecto_id, partida_id, no_lote, articulo, categoria_id, descripcion, cantidad, precio, iva, total, url, autorizado, observaciones) FROM stdin;
\.
COPY anuencias_tecnicas_anuencia_detalle (id, fecha_registro, fecha_ultimo_cambio, activo, usuario_id, anuencia_id, proyecto_id, partida_id, no_lote, articulo, categoria_id, descripcion, cantidad, precio, iva, total, url, autorizado, observaciones) FROM '$$PATH$$/2133.dat';

--
-- Name: anuencias_tecnicas_anuencia_detalle_id_seq; Type: SEQUENCE SET; Schema: public; Owner: Produccion
--

SELECT pg_catalog.setval('anuencias_tecnicas_anuencia_detalle_id_seq', 4566, true);


--
-- Data for Name: anuencias_tecnicas_articulos; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY anuencias_tecnicas_articulos (id, fecha_registro, fecha_ultimo_cambio, activo, usuario_id, anuencia_id, articulo, descripcion, cantidad, precio, url, autorizado, no_lote, observaciones) FROM stdin;
\.
COPY anuencias_tecnicas_articulos (id, fecha_registro, fecha_ultimo_cambio, activo, usuario_id, anuencia_id, articulo, descripcion, cantidad, precio, url, autorizado, no_lote, observaciones) FROM '$$PATH$$/2135.dat';

--
-- Name: anuencias_tecnicas_articulos_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('anuencias_tecnicas_articulos_id_seq', 4, true);


--
-- Data for Name: anuencias_tecnicas_author; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY anuencias_tecnicas_author (id, name) FROM stdin;
\.
COPY anuencias_tecnicas_author (id, name) FROM '$$PATH$$/2137.dat';

--
-- Name: anuencias_tecnicas_author_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('anuencias_tecnicas_author_id_seq', 1, false);


--
-- Data for Name: anuencias_tecnicas_autorizacion; Type: TABLE DATA; Schema: public; Owner: Produccion
--

COPY anuencias_tecnicas_autorizacion (id, fecha_registro, fecha_ultimo_cambio, activo, usuario_id, anuencia_id) FROM stdin;
\.
COPY anuencias_tecnicas_autorizacion (id, fecha_registro, fecha_ultimo_cambio, activo, usuario_id, anuencia_id) FROM '$$PATH$$/2139.dat';

--
-- Name: anuencias_tecnicas_autorizacion_id_seq; Type: SEQUENCE SET; Schema: public; Owner: Produccion
--

SELECT pg_catalog.setval('anuencias_tecnicas_autorizacion_id_seq', 1, false);


--
-- Data for Name: anuencias_tecnicas_book; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY anuencias_tecnicas_book (id, author_id, title) FROM stdin;
\.
COPY anuencias_tecnicas_book (id, author_id, title) FROM '$$PATH$$/2141.dat';

--
-- Name: anuencias_tecnicas_book_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('anuencias_tecnicas_book_id_seq', 1, false);


--
-- Data for Name: anuencias_tecnicas_catalogodependencias; Type: TABLE DATA; Schema: public; Owner: Produccion
--

COPY anuencias_tecnicas_catalogodependencias (id, clave, nombre, ejercicio) FROM stdin;
\.
COPY anuencias_tecnicas_catalogodependencias (id, clave, nombre, ejercicio) FROM '$$PATH$$/2143.dat';

--
-- Name: anuencias_tecnicas_catalogodependencias_id_seq; Type: SEQUENCE SET; Schema: public; Owner: Produccion
--

SELECT pg_catalog.setval('anuencias_tecnicas_catalogodependencias_id_seq', 8, true);


--
-- Data for Name: anuencias_tecnicas_categoria; Type: TABLE DATA; Schema: public; Owner: Produccion
--

COPY anuencias_tecnicas_categoria (id, clave, descripcion) FROM stdin;
\.
COPY anuencias_tecnicas_categoria (id, clave, descripcion) FROM '$$PATH$$/2145.dat';

--
-- Name: anuencias_tecnicas_categoria_id_seq; Type: SEQUENCE SET; Schema: public; Owner: Produccion
--

SELECT pg_catalog.setval('anuencias_tecnicas_categoria_id_seq', 12, true);


--
-- Data for Name: anuencias_tecnicas_estatus; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY anuencias_tecnicas_estatus (id, fecha_registro, fecha_ultimo_cambio, activo, usuario_id, clave, nombre, descripcion, color, secuencia) FROM stdin;
\.
COPY anuencias_tecnicas_estatus (id, fecha_registro, fecha_ultimo_cambio, activo, usuario_id, clave, nombre, descripcion, color, secuencia) FROM '$$PATH$$/2147.dat';

--
-- Name: anuencias_tecnicas_estatus_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('anuencias_tecnicas_estatus_id_seq', 12, true);


--
-- Data for Name: anuencias_tecnicas_perfil; Type: TABLE DATA; Schema: public; Owner: Produccion
--

COPY anuencias_tecnicas_perfil (id, tipo_id, usuario_id, direccion_id) FROM stdin;
\.
COPY anuencias_tecnicas_perfil (id, tipo_id, usuario_id, direccion_id) FROM '$$PATH$$/2149.dat';

--
-- Name: anuencias_tecnicas_perfil_id_seq; Type: SEQUENCE SET; Schema: public; Owner: Produccion
--

SELECT pg_catalog.setval('anuencias_tecnicas_perfil_id_seq', 138, true);


--
-- Data for Name: anuencias_tecnicas_revision; Type: TABLE DATA; Schema: public; Owner: Produccion
--

COPY anuencias_tecnicas_revision (id, fecha_registro, fecha_ultimo_cambio, activo, usuario_id, anuencia_id) FROM stdin;
\.
COPY anuencias_tecnicas_revision (id, fecha_registro, fecha_ultimo_cambio, activo, usuario_id, anuencia_id) FROM '$$PATH$$/2151.dat';

--
-- Name: anuencias_tecnicas_revision_id_seq; Type: SEQUENCE SET; Schema: public; Owner: Produccion
--

SELECT pg_catalog.setval('anuencias_tecnicas_revision_id_seq', 679, true);


--
-- Data for Name: anuencias_tecnicas_tipo_usuario; Type: TABLE DATA; Schema: public; Owner: Produccion
--

COPY anuencias_tecnicas_tipo_usuario (id, clave, nombre) FROM stdin;
\.
COPY anuencias_tecnicas_tipo_usuario (id, clave, nombre) FROM '$$PATH$$/2153.dat';

--
-- Name: anuencias_tecnicas_tipo_usuario_id_seq; Type: SEQUENCE SET; Schema: public; Owner: Produccion
--

SELECT pg_catalog.setval('anuencias_tecnicas_tipo_usuario_id_seq', 4, true);


--
-- Data for Name: anuencias_tecnicas_usuario_dependencia; Type: TABLE DATA; Schema: public; Owner: Produccion
--

COPY anuencias_tecnicas_usuario_dependencia (id, usuario_id, dependencia_id) FROM stdin;
\.
COPY anuencias_tecnicas_usuario_dependencia (id, usuario_id, dependencia_id) FROM '$$PATH$$/2155.dat';

--
-- Name: anuencias_tecnicas_usuario_dependencia_id_seq; Type: SEQUENCE SET; Schema: public; Owner: Produccion
--

SELECT pg_catalog.setval('anuencias_tecnicas_usuario_dependencia_id_seq', 136, true);


--
-- Data for Name: auth_group; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY auth_group (id, name) FROM stdin;
\.
COPY auth_group (id, name) FROM '$$PATH$$/2157.dat';

--
-- Name: auth_group_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('auth_group_id_seq', 4, true);


--
-- Data for Name: auth_group_permissions; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY auth_group_permissions (id, group_id, permission_id) FROM stdin;
\.
COPY auth_group_permissions (id, group_id, permission_id) FROM '$$PATH$$/2159.dat';

--
-- Name: auth_group_permissions_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('auth_group_permissions_id_seq', 562, true);


--
-- Data for Name: auth_permission; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY auth_permission (id, name, content_type_id, codename) FROM stdin;
\.
COPY auth_permission (id, name, content_type_id, codename) FROM '$$PATH$$/2161.dat';

--
-- Name: auth_permission_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('auth_permission_id_seq', 105, true);


--
-- Data for Name: auth_user; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY auth_user (id, password, last_login, is_superuser, username, first_name, last_name, email, is_staff, is_active, date_joined) FROM stdin;
\.
COPY auth_user (id, password, last_login, is_superuser, username, first_name, last_name, email, is_staff, is_active, date_joined) FROM '$$PATH$$/2163.dat';

--
-- Data for Name: auth_user_groups; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY auth_user_groups (id, user_id, group_id) FROM stdin;
\.
COPY auth_user_groups (id, user_id, group_id) FROM '$$PATH$$/2164.dat';

--
-- Name: auth_user_groups_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('auth_user_groups_id_seq', 230, true);


--
-- Name: auth_user_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('auth_user_id_seq', 148, true);


--
-- Data for Name: auth_user_user_permissions; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY auth_user_user_permissions (id, user_id, permission_id) FROM stdin;
\.
COPY auth_user_user_permissions (id, user_id, permission_id) FROM '$$PATH$$/2167.dat';

--
-- Name: auth_user_user_permissions_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('auth_user_user_permissions_id_seq', 72, true);


--
-- Data for Name: dependencias_adscripcion; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY dependencias_adscripcion (id, adscripcion_padre_id, nombre, siglas, logo, activo, fecha_baja, fecha_alta) FROM stdin;
\.
COPY dependencias_adscripcion (id, adscripcion_padre_id, nombre, siglas, logo, activo, fecha_baja, fecha_alta) FROM '$$PATH$$/2169.dat';

--
-- Name: dependencias_adscripcion_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('dependencias_adscripcion_id_seq', 81, true);


--
-- Data for Name: dependencias_perfil; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY dependencias_perfil (id, tipo_id, usuario_id, direccion_id) FROM stdin;
\.
COPY dependencias_perfil (id, tipo_id, usuario_id, direccion_id) FROM '$$PATH$$/2171.dat';

--
-- Name: dependencias_perfil_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('dependencias_perfil_id_seq', 113, true);


--
-- Data for Name: dependencias_tipo_usuario; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY dependencias_tipo_usuario (id, clave, nombre) FROM stdin;
\.
COPY dependencias_tipo_usuario (id, clave, nombre) FROM '$$PATH$$/2173.dat';

--
-- Name: dependencias_tipo_usuario_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('dependencias_tipo_usuario_id_seq', 3, true);


--
-- Data for Name: django_admin_log; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY django_admin_log (id, action_time, user_id, content_type_id, object_id, object_repr, action_flag, change_message) FROM stdin;
\.
COPY django_admin_log (id, action_time, user_id, content_type_id, object_id, object_repr, action_flag, change_message) FROM '$$PATH$$/2175.dat';

--
-- Name: django_admin_log_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('django_admin_log_id_seq', 1574, true);


--
-- Data for Name: django_content_type; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY django_content_type (id, name, app_label, model) FROM stdin;
\.
COPY django_content_type (id, name, app_label, model) FROM '$$PATH$$/2177.dat';

--
-- Name: django_content_type_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('django_content_type_id_seq', 35, true);


--
-- Data for Name: django_session; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY django_session (session_key, session_data, expire_date) FROM stdin;
\.
COPY django_session (session_key, session_data, expire_date) FROM '$$PATH$$/2179.dat';

--
-- Data for Name: django_site; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY django_site (id, domain, name) FROM stdin;
\.
COPY django_site (id, domain, name) FROM '$$PATH$$/2180.dat';

--
-- Name: django_site_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('django_site_id_seq', 1, true);


--
-- Name: anuencias_tecnicas_addpartidas_pkey; Type: CONSTRAINT; Schema: public; Owner: Produccion; Tablespace: 
--

ALTER TABLE ONLY anuencias_tecnicas_addpartidas
    ADD CONSTRAINT anuencias_tecnicas_addpartidas_pkey PRIMARY KEY (id);


--
-- Name: anuencias_tecnicas_addpartidas_proyectos_addpartidas_id_key; Type: CONSTRAINT; Schema: public; Owner: Produccion; Tablespace: 
--

ALTER TABLE ONLY anuencias_tecnicas_addpartidas_proyectos
    ADD CONSTRAINT anuencias_tecnicas_addpartidas_proyectos_addpartidas_id_key UNIQUE (addpartidas_id, addproyectos_id);


--
-- Name: anuencias_tecnicas_addpartidas_proyectos_pkey; Type: CONSTRAINT; Schema: public; Owner: Produccion; Tablespace: 
--

ALTER TABLE ONLY anuencias_tecnicas_addpartidas_proyectos
    ADD CONSTRAINT anuencias_tecnicas_addpartidas_proyectos_pkey PRIMARY KEY (id);


--
-- Name: anuencias_tecnicas_addproyectos_pkey; Type: CONSTRAINT; Schema: public; Owner: Produccion; Tablespace: 
--

ALTER TABLE ONLY anuencias_tecnicas_addproyectos
    ADD CONSTRAINT anuencias_tecnicas_addproyectos_pkey PRIMARY KEY (id);


--
-- Name: anuencias_tecnicas_anuencia_datos_pkey; Type: CONSTRAINT; Schema: public; Owner: Produccion; Tablespace: 
--

ALTER TABLE ONLY anuencias_tecnicas_anuencia_datos
    ADD CONSTRAINT anuencias_tecnicas_anuencia_datos_pkey PRIMARY KEY (id);


--
-- Name: anuencias_tecnicas_anuencia_detalle_pkey; Type: CONSTRAINT; Schema: public; Owner: Produccion; Tablespace: 
--

ALTER TABLE ONLY anuencias_tecnicas_anuencia_detalle
    ADD CONSTRAINT anuencias_tecnicas_anuencia_detalle_pkey PRIMARY KEY (id);


--
-- Name: anuencias_tecnicas_articulos_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY anuencias_tecnicas_articulos
    ADD CONSTRAINT anuencias_tecnicas_articulos_pkey PRIMARY KEY (id);


--
-- Name: anuencias_tecnicas_author_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY anuencias_tecnicas_author
    ADD CONSTRAINT anuencias_tecnicas_author_pkey PRIMARY KEY (id);


--
-- Name: anuencias_tecnicas_autorizacion_pkey; Type: CONSTRAINT; Schema: public; Owner: Produccion; Tablespace: 
--

ALTER TABLE ONLY anuencias_tecnicas_autorizacion
    ADD CONSTRAINT anuencias_tecnicas_autorizacion_pkey PRIMARY KEY (id);


--
-- Name: anuencias_tecnicas_book_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY anuencias_tecnicas_book
    ADD CONSTRAINT anuencias_tecnicas_book_pkey PRIMARY KEY (id);


--
-- Name: anuencias_tecnicas_catalogodependencias_pkey; Type: CONSTRAINT; Schema: public; Owner: Produccion; Tablespace: 
--

ALTER TABLE ONLY anuencias_tecnicas_catalogodependencias
    ADD CONSTRAINT anuencias_tecnicas_catalogodependencias_pkey PRIMARY KEY (id);


--
-- Name: anuencias_tecnicas_categoria_pkey; Type: CONSTRAINT; Schema: public; Owner: Produccion; Tablespace: 
--

ALTER TABLE ONLY anuencias_tecnicas_categoria
    ADD CONSTRAINT anuencias_tecnicas_categoria_pkey PRIMARY KEY (id);


--
-- Name: anuencias_tecnicas_estatus_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY anuencias_tecnicas_estatus
    ADD CONSTRAINT anuencias_tecnicas_estatus_pkey PRIMARY KEY (id);


--
-- Name: anuencias_tecnicas_perfil_pkey; Type: CONSTRAINT; Schema: public; Owner: Produccion; Tablespace: 
--

ALTER TABLE ONLY anuencias_tecnicas_perfil
    ADD CONSTRAINT anuencias_tecnicas_perfil_pkey PRIMARY KEY (id);


--
-- Name: anuencias_tecnicas_perfil_usuario_id_key; Type: CONSTRAINT; Schema: public; Owner: Produccion; Tablespace: 
--

ALTER TABLE ONLY anuencias_tecnicas_perfil
    ADD CONSTRAINT anuencias_tecnicas_perfil_usuario_id_key UNIQUE (usuario_id);


--
-- Name: anuencias_tecnicas_revision_pkey; Type: CONSTRAINT; Schema: public; Owner: Produccion; Tablespace: 
--

ALTER TABLE ONLY anuencias_tecnicas_revision
    ADD CONSTRAINT anuencias_tecnicas_revision_pkey PRIMARY KEY (id);


--
-- Name: anuencias_tecnicas_tipo_usuario_pkey; Type: CONSTRAINT; Schema: public; Owner: Produccion; Tablespace: 
--

ALTER TABLE ONLY anuencias_tecnicas_tipo_usuario
    ADD CONSTRAINT anuencias_tecnicas_tipo_usuario_pkey PRIMARY KEY (id);


--
-- Name: anuencias_tecnicas_usuario_dependencia_pkey; Type: CONSTRAINT; Schema: public; Owner: Produccion; Tablespace: 
--

ALTER TABLE ONLY anuencias_tecnicas_usuario_dependencia
    ADD CONSTRAINT anuencias_tecnicas_usuario_dependencia_pkey PRIMARY KEY (id);


--
-- Name: auth_group_name_key; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY auth_group
    ADD CONSTRAINT auth_group_name_key UNIQUE (name);


--
-- Name: auth_group_permissions_group_id_permission_id_key; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY auth_group_permissions
    ADD CONSTRAINT auth_group_permissions_group_id_permission_id_key UNIQUE (group_id, permission_id);


--
-- Name: auth_group_permissions_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY auth_group_permissions
    ADD CONSTRAINT auth_group_permissions_pkey PRIMARY KEY (id);


--
-- Name: auth_group_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY auth_group
    ADD CONSTRAINT auth_group_pkey PRIMARY KEY (id);


--
-- Name: auth_permission_content_type_id_codename_key; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY auth_permission
    ADD CONSTRAINT auth_permission_content_type_id_codename_key UNIQUE (content_type_id, codename);


--
-- Name: auth_permission_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY auth_permission
    ADD CONSTRAINT auth_permission_pkey PRIMARY KEY (id);


--
-- Name: auth_user_groups_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY auth_user_groups
    ADD CONSTRAINT auth_user_groups_pkey PRIMARY KEY (id);


--
-- Name: auth_user_groups_user_id_group_id_key; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY auth_user_groups
    ADD CONSTRAINT auth_user_groups_user_id_group_id_key UNIQUE (user_id, group_id);


--
-- Name: auth_user_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY auth_user
    ADD CONSTRAINT auth_user_pkey PRIMARY KEY (id);


--
-- Name: auth_user_user_permissions_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY auth_user_user_permissions
    ADD CONSTRAINT auth_user_user_permissions_pkey PRIMARY KEY (id);


--
-- Name: auth_user_user_permissions_user_id_permission_id_key; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY auth_user_user_permissions
    ADD CONSTRAINT auth_user_user_permissions_user_id_permission_id_key UNIQUE (user_id, permission_id);


--
-- Name: auth_user_username_key; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY auth_user
    ADD CONSTRAINT auth_user_username_key UNIQUE (username);


--
-- Name: dependencias_adscripcion_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY dependencias_adscripcion
    ADD CONSTRAINT dependencias_adscripcion_pkey PRIMARY KEY (id);


--
-- Name: dependencias_perfil_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY dependencias_perfil
    ADD CONSTRAINT dependencias_perfil_pkey PRIMARY KEY (id);


--
-- Name: dependencias_tipo_usuario_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY dependencias_tipo_usuario
    ADD CONSTRAINT dependencias_tipo_usuario_pkey PRIMARY KEY (id);


--
-- Name: django_admin_log_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY django_admin_log
    ADD CONSTRAINT django_admin_log_pkey PRIMARY KEY (id);


--
-- Name: django_content_type_app_label_model_key; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY django_content_type
    ADD CONSTRAINT django_content_type_app_label_model_key UNIQUE (app_label, model);


--
-- Name: django_content_type_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY django_content_type
    ADD CONSTRAINT django_content_type_pkey PRIMARY KEY (id);


--
-- Name: django_session_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY django_session
    ADD CONSTRAINT django_session_pkey PRIMARY KEY (session_key);


--
-- Name: django_site_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY django_site
    ADD CONSTRAINT django_site_pkey PRIMARY KEY (id);


--
-- Name: anuencias_tecnicas_addpartidas_proyectos_addpartidas_id; Type: INDEX; Schema: public; Owner: Produccion; Tablespace: 
--

CREATE INDEX anuencias_tecnicas_addpartidas_proyectos_addpartidas_id ON anuencias_tecnicas_addpartidas_proyectos USING btree (addpartidas_id);


--
-- Name: anuencias_tecnicas_addpartidas_proyectos_addproyectos_id; Type: INDEX; Schema: public; Owner: Produccion; Tablespace: 
--

CREATE INDEX anuencias_tecnicas_addpartidas_proyectos_addproyectos_id ON anuencias_tecnicas_addpartidas_proyectos USING btree (addproyectos_id);


--
-- Name: anuencias_tecnicas_addproyectos_dependencia_id; Type: INDEX; Schema: public; Owner: Produccion; Tablespace: 
--

CREATE INDEX anuencias_tecnicas_addproyectos_dependencia_id ON anuencias_tecnicas_addproyectos USING btree (dependencia_id);


--
-- Name: anuencias_tecnicas_anuencia_datos_dependencias_id; Type: INDEX; Schema: public; Owner: Produccion; Tablespace: 
--

CREATE INDEX anuencias_tecnicas_anuencia_datos_dependencias_id ON anuencias_tecnicas_anuencia_datos USING btree (dependencias_id);


--
-- Name: anuencias_tecnicas_anuencia_datos_estatus_id; Type: INDEX; Schema: public; Owner: Produccion; Tablespace: 
--

CREATE INDEX anuencias_tecnicas_anuencia_datos_estatus_id ON anuencias_tecnicas_anuencia_datos USING btree (estatus_id);


--
-- Name: anuencias_tecnicas_anuencia_datos_usuario_id; Type: INDEX; Schema: public; Owner: Produccion; Tablespace: 
--

CREATE INDEX anuencias_tecnicas_anuencia_datos_usuario_id ON anuencias_tecnicas_anuencia_datos USING btree (usuario_id);


--
-- Name: anuencias_tecnicas_anuencia_detalle_anuencia_id; Type: INDEX; Schema: public; Owner: Produccion; Tablespace: 
--

CREATE INDEX anuencias_tecnicas_anuencia_detalle_anuencia_id ON anuencias_tecnicas_anuencia_detalle USING btree (anuencia_id);


--
-- Name: anuencias_tecnicas_anuencia_detalle_categoria_id; Type: INDEX; Schema: public; Owner: Produccion; Tablespace: 
--

CREATE INDEX anuencias_tecnicas_anuencia_detalle_categoria_id ON anuencias_tecnicas_anuencia_detalle USING btree (categoria_id);


--
-- Name: anuencias_tecnicas_anuencia_detalle_partida_id; Type: INDEX; Schema: public; Owner: Produccion; Tablespace: 
--

CREATE INDEX anuencias_tecnicas_anuencia_detalle_partida_id ON anuencias_tecnicas_anuencia_detalle USING btree (partida_id);


--
-- Name: anuencias_tecnicas_anuencia_detalle_proyecto_id; Type: INDEX; Schema: public; Owner: Produccion; Tablespace: 
--

CREATE INDEX anuencias_tecnicas_anuencia_detalle_proyecto_id ON anuencias_tecnicas_anuencia_detalle USING btree (proyecto_id);


--
-- Name: anuencias_tecnicas_anuencia_detalle_usuario_id; Type: INDEX; Schema: public; Owner: Produccion; Tablespace: 
--

CREATE INDEX anuencias_tecnicas_anuencia_detalle_usuario_id ON anuencias_tecnicas_anuencia_detalle USING btree (usuario_id);


--
-- Name: anuencias_tecnicas_articulos_anuencia_id; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX anuencias_tecnicas_articulos_anuencia_id ON anuencias_tecnicas_articulos USING btree (anuencia_id);


--
-- Name: anuencias_tecnicas_articulos_usuario_id; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX anuencias_tecnicas_articulos_usuario_id ON anuencias_tecnicas_articulos USING btree (usuario_id);


--
-- Name: anuencias_tecnicas_autorizacion_anuencia_id; Type: INDEX; Schema: public; Owner: Produccion; Tablespace: 
--

CREATE INDEX anuencias_tecnicas_autorizacion_anuencia_id ON anuencias_tecnicas_autorizacion USING btree (anuencia_id);


--
-- Name: anuencias_tecnicas_autorizacion_usuario_id; Type: INDEX; Schema: public; Owner: Produccion; Tablespace: 
--

CREATE INDEX anuencias_tecnicas_autorizacion_usuario_id ON anuencias_tecnicas_autorizacion USING btree (usuario_id);


--
-- Name: anuencias_tecnicas_book_author_id; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX anuencias_tecnicas_book_author_id ON anuencias_tecnicas_book USING btree (author_id);


--
-- Name: anuencias_tecnicas_estatus_usuario_id; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX anuencias_tecnicas_estatus_usuario_id ON anuencias_tecnicas_estatus USING btree (usuario_id);


--
-- Name: anuencias_tecnicas_perfil_direccion_id; Type: INDEX; Schema: public; Owner: Produccion; Tablespace: 
--

CREATE INDEX anuencias_tecnicas_perfil_direccion_id ON anuencias_tecnicas_perfil USING btree (direccion_id);


--
-- Name: anuencias_tecnicas_perfil_tipo_id; Type: INDEX; Schema: public; Owner: Produccion; Tablespace: 
--

CREATE INDEX anuencias_tecnicas_perfil_tipo_id ON anuencias_tecnicas_perfil USING btree (tipo_id);


--
-- Name: anuencias_tecnicas_perfil_usuario_id; Type: INDEX; Schema: public; Owner: Produccion; Tablespace: 
--

CREATE INDEX anuencias_tecnicas_perfil_usuario_id ON anuencias_tecnicas_perfil USING btree (usuario_id);


--
-- Name: anuencias_tecnicas_revision_anuencia_id; Type: INDEX; Schema: public; Owner: Produccion; Tablespace: 
--

CREATE INDEX anuencias_tecnicas_revision_anuencia_id ON anuencias_tecnicas_revision USING btree (anuencia_id);


--
-- Name: anuencias_tecnicas_revision_usuario_id; Type: INDEX; Schema: public; Owner: Produccion; Tablespace: 
--

CREATE INDEX anuencias_tecnicas_revision_usuario_id ON anuencias_tecnicas_revision USING btree (usuario_id);


--
-- Name: anuencias_tecnicas_usuario_dependencia_dependencia_id; Type: INDEX; Schema: public; Owner: Produccion; Tablespace: 
--

CREATE INDEX anuencias_tecnicas_usuario_dependencia_dependencia_id ON anuencias_tecnicas_usuario_dependencia USING btree (dependencia_id);


--
-- Name: anuencias_tecnicas_usuario_dependencia_usuario_id; Type: INDEX; Schema: public; Owner: Produccion; Tablespace: 
--

CREATE INDEX anuencias_tecnicas_usuario_dependencia_usuario_id ON anuencias_tecnicas_usuario_dependencia USING btree (usuario_id);


--
-- Name: auth_group_name_like; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX auth_group_name_like ON auth_group USING btree (name varchar_pattern_ops);


--
-- Name: auth_group_permissions_group_id; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX auth_group_permissions_group_id ON auth_group_permissions USING btree (group_id);


--
-- Name: auth_group_permissions_permission_id; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX auth_group_permissions_permission_id ON auth_group_permissions USING btree (permission_id);


--
-- Name: auth_permission_content_type_id; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX auth_permission_content_type_id ON auth_permission USING btree (content_type_id);


--
-- Name: auth_user_groups_group_id; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX auth_user_groups_group_id ON auth_user_groups USING btree (group_id);


--
-- Name: auth_user_groups_user_id; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX auth_user_groups_user_id ON auth_user_groups USING btree (user_id);


--
-- Name: auth_user_user_permissions_permission_id; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX auth_user_user_permissions_permission_id ON auth_user_user_permissions USING btree (permission_id);


--
-- Name: auth_user_user_permissions_user_id; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX auth_user_user_permissions_user_id ON auth_user_user_permissions USING btree (user_id);


--
-- Name: auth_user_username_like; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX auth_user_username_like ON auth_user USING btree (username varchar_pattern_ops);


--
-- Name: dependencias_adscripcion_adscripcion_padre_id; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX dependencias_adscripcion_adscripcion_padre_id ON dependencias_adscripcion USING btree (adscripcion_padre_id);


--
-- Name: dependencias_perfil_direccion_id; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX dependencias_perfil_direccion_id ON dependencias_perfil USING btree (direccion_id);


--
-- Name: dependencias_perfil_tipo_id; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX dependencias_perfil_tipo_id ON dependencias_perfil USING btree (tipo_id);


--
-- Name: dependencias_perfil_usuario_id; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX dependencias_perfil_usuario_id ON dependencias_perfil USING btree (usuario_id);


--
-- Name: django_admin_log_content_type_id; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX django_admin_log_content_type_id ON django_admin_log USING btree (content_type_id);


--
-- Name: django_admin_log_user_id; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX django_admin_log_user_id ON django_admin_log USING btree (user_id);


--
-- Name: django_session_expire_date; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX django_session_expire_date ON django_session USING btree (expire_date);


--
-- Name: django_session_session_key_like; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX django_session_session_key_like ON django_session USING btree (session_key varchar_pattern_ops);


--
-- Name: addpartidas_id_refs_id_7ef15694; Type: FK CONSTRAINT; Schema: public; Owner: Produccion
--

ALTER TABLE ONLY anuencias_tecnicas_addpartidas_proyectos
    ADD CONSTRAINT addpartidas_id_refs_id_7ef15694 FOREIGN KEY (addpartidas_id) REFERENCES anuencias_tecnicas_addpartidas(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: adscripcion_padre_id_refs_id_8b3e7743; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY dependencias_adscripcion
    ADD CONSTRAINT adscripcion_padre_id_refs_id_8b3e7743 FOREIGN KEY (adscripcion_padre_id) REFERENCES dependencias_adscripcion(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: anuencias_tecnicas_addpartidas_proyectos_addproyectos_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: Produccion
--

ALTER TABLE ONLY anuencias_tecnicas_addpartidas_proyectos
    ADD CONSTRAINT anuencias_tecnicas_addpartidas_proyectos_addproyectos_id_fkey FOREIGN KEY (addproyectos_id) REFERENCES anuencias_tecnicas_addproyectos(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: anuencias_tecnicas_addproyectos_dependencia_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: Produccion
--

ALTER TABLE ONLY anuencias_tecnicas_addproyectos
    ADD CONSTRAINT anuencias_tecnicas_addproyectos_dependencia_id_fkey FOREIGN KEY (dependencia_id) REFERENCES anuencias_tecnicas_catalogodependencias(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: anuencias_tecnicas_anuencia_datos_dependencias_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: Produccion
--

ALTER TABLE ONLY anuencias_tecnicas_anuencia_datos
    ADD CONSTRAINT anuencias_tecnicas_anuencia_datos_dependencias_id_fkey FOREIGN KEY (dependencias_id) REFERENCES anuencias_tecnicas_catalogodependencias(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: anuencias_tecnicas_anuencia_datos_estatus_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: Produccion
--

ALTER TABLE ONLY anuencias_tecnicas_anuencia_datos
    ADD CONSTRAINT anuencias_tecnicas_anuencia_datos_estatus_id_fkey FOREIGN KEY (estatus_id) REFERENCES anuencias_tecnicas_estatus(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: anuencias_tecnicas_anuencia_datos_usuario_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: Produccion
--

ALTER TABLE ONLY anuencias_tecnicas_anuencia_datos
    ADD CONSTRAINT anuencias_tecnicas_anuencia_datos_usuario_id_fkey FOREIGN KEY (usuario_id) REFERENCES auth_user(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: anuencias_tecnicas_anuencia_detalle_anuencia_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: Produccion
--

ALTER TABLE ONLY anuencias_tecnicas_anuencia_detalle
    ADD CONSTRAINT anuencias_tecnicas_anuencia_detalle_anuencia_id_fkey FOREIGN KEY (anuencia_id) REFERENCES anuencias_tecnicas_anuencia_datos(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: anuencias_tecnicas_anuencia_detalle_categoria_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: Produccion
--

ALTER TABLE ONLY anuencias_tecnicas_anuencia_detalle
    ADD CONSTRAINT anuencias_tecnicas_anuencia_detalle_categoria_id_fkey FOREIGN KEY (categoria_id) REFERENCES anuencias_tecnicas_categoria(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: anuencias_tecnicas_anuencia_detalle_partida_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: Produccion
--

ALTER TABLE ONLY anuencias_tecnicas_anuencia_detalle
    ADD CONSTRAINT anuencias_tecnicas_anuencia_detalle_partida_id_fkey FOREIGN KEY (partida_id) REFERENCES anuencias_tecnicas_addpartidas(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: anuencias_tecnicas_anuencia_detalle_proyecto_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: Produccion
--

ALTER TABLE ONLY anuencias_tecnicas_anuencia_detalle
    ADD CONSTRAINT anuencias_tecnicas_anuencia_detalle_proyecto_id_fkey FOREIGN KEY (proyecto_id) REFERENCES anuencias_tecnicas_addproyectos(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: anuencias_tecnicas_anuencia_detalle_usuario_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: Produccion
--

ALTER TABLE ONLY anuencias_tecnicas_anuencia_detalle
    ADD CONSTRAINT anuencias_tecnicas_anuencia_detalle_usuario_id_fkey FOREIGN KEY (usuario_id) REFERENCES auth_user(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: anuencias_tecnicas_articulos_usuario_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY anuencias_tecnicas_articulos
    ADD CONSTRAINT anuencias_tecnicas_articulos_usuario_id_fkey FOREIGN KEY (usuario_id) REFERENCES auth_user(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: anuencias_tecnicas_autorizacion_usuario_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: Produccion
--

ALTER TABLE ONLY anuencias_tecnicas_autorizacion
    ADD CONSTRAINT anuencias_tecnicas_autorizacion_usuario_id_fkey FOREIGN KEY (usuario_id) REFERENCES auth_user(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: anuencias_tecnicas_book_author_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY anuencias_tecnicas_book
    ADD CONSTRAINT anuencias_tecnicas_book_author_id_fkey FOREIGN KEY (author_id) REFERENCES anuencias_tecnicas_author(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: anuencias_tecnicas_estatus_usuario_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY anuencias_tecnicas_estatus
    ADD CONSTRAINT anuencias_tecnicas_estatus_usuario_id_fkey FOREIGN KEY (usuario_id) REFERENCES auth_user(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: anuencias_tecnicas_perfil_direccion_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: Produccion
--

ALTER TABLE ONLY anuencias_tecnicas_perfil
    ADD CONSTRAINT anuencias_tecnicas_perfil_direccion_id_fkey FOREIGN KEY (direccion_id) REFERENCES anuencias_tecnicas_catalogodependencias(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: anuencias_tecnicas_perfil_tipo_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: Produccion
--

ALTER TABLE ONLY anuencias_tecnicas_perfil
    ADD CONSTRAINT anuencias_tecnicas_perfil_tipo_id_fkey FOREIGN KEY (tipo_id) REFERENCES anuencias_tecnicas_tipo_usuario(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: anuencias_tecnicas_perfil_usuario_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: Produccion
--

ALTER TABLE ONLY anuencias_tecnicas_perfil
    ADD CONSTRAINT anuencias_tecnicas_perfil_usuario_id_fkey FOREIGN KEY (usuario_id) REFERENCES auth_user(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: anuencias_tecnicas_revision_usuario_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: Produccion
--

ALTER TABLE ONLY anuencias_tecnicas_revision
    ADD CONSTRAINT anuencias_tecnicas_revision_usuario_id_fkey FOREIGN KEY (usuario_id) REFERENCES auth_user(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: anuencias_tecnicas_usuario_dependencia_dependencia_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: Produccion
--

ALTER TABLE ONLY anuencias_tecnicas_usuario_dependencia
    ADD CONSTRAINT anuencias_tecnicas_usuario_dependencia_dependencia_id_fkey FOREIGN KEY (dependencia_id) REFERENCES anuencias_tecnicas_catalogodependencias(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: anuencias_tecnicas_usuario_dependencia_usuario_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: Produccion
--

ALTER TABLE ONLY anuencias_tecnicas_usuario_dependencia
    ADD CONSTRAINT anuencias_tecnicas_usuario_dependencia_usuario_id_fkey FOREIGN KEY (usuario_id) REFERENCES auth_user(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: auth_group_permissions_permission_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY auth_group_permissions
    ADD CONSTRAINT auth_group_permissions_permission_id_fkey FOREIGN KEY (permission_id) REFERENCES auth_permission(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: auth_user_groups_group_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY auth_user_groups
    ADD CONSTRAINT auth_user_groups_group_id_fkey FOREIGN KEY (group_id) REFERENCES auth_group(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: auth_user_user_permissions_permission_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY auth_user_user_permissions
    ADD CONSTRAINT auth_user_user_permissions_permission_id_fkey FOREIGN KEY (permission_id) REFERENCES auth_permission(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: content_type_id_refs_id_d043b34a; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY auth_permission
    ADD CONSTRAINT content_type_id_refs_id_d043b34a FOREIGN KEY (content_type_id) REFERENCES django_content_type(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: dependencias_perfil_direccion_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY dependencias_perfil
    ADD CONSTRAINT dependencias_perfil_direccion_id_fkey FOREIGN KEY (direccion_id) REFERENCES dependencias_adscripcion(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: dependencias_perfil_tipo_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY dependencias_perfil
    ADD CONSTRAINT dependencias_perfil_tipo_id_fkey FOREIGN KEY (tipo_id) REFERENCES dependencias_tipo_usuario(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: dependencias_perfil_usuario_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY dependencias_perfil
    ADD CONSTRAINT dependencias_perfil_usuario_id_fkey FOREIGN KEY (usuario_id) REFERENCES auth_user(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: django_admin_log_content_type_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY django_admin_log
    ADD CONSTRAINT django_admin_log_content_type_id_fkey FOREIGN KEY (content_type_id) REFERENCES django_content_type(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: django_admin_log_user_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY django_admin_log
    ADD CONSTRAINT django_admin_log_user_id_fkey FOREIGN KEY (user_id) REFERENCES auth_user(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: group_id_refs_id_f4b32aac; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY auth_group_permissions
    ADD CONSTRAINT group_id_refs_id_f4b32aac FOREIGN KEY (group_id) REFERENCES auth_group(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: user_id_refs_id_40c41112; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY auth_user_groups
    ADD CONSTRAINT user_id_refs_id_40c41112 FOREIGN KEY (user_id) REFERENCES auth_user(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: user_id_refs_id_4dc23c39; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY auth_user_user_permissions
    ADD CONSTRAINT user_id_refs_id_4dc23c39 FOREIGN KEY (user_id) REFERENCES auth_user(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: public; Type: ACL; Schema: -; Owner: postgres
--

REVOKE ALL ON SCHEMA public FROM PUBLIC;
REVOKE ALL ON SCHEMA public FROM postgres;
GRANT ALL ON SCHEMA public TO postgres;
GRANT ALL ON SCHEMA public TO PUBLIC;


--
-- PostgreSQL database dump complete
--

